<?php
/*******************************************************************************
 *	DOM for JAPRO Template Engine
 *     Ver. 0.9
 *******************************************************************************/

// file_get_contents

if ( ! function_exists( 'file_get_contents' ) ) {
	function file_get_contents( $path ) {
		if ( ( $fh = fopen( $path, 'r' ) ) === false ) return false ;
		
		$contents = '' ;
		
		while( $buffer = fgets( $fh, 4096 ) ) $contents .= $buffer ;
		
		fclose( $fh ) ;
		
		return $contents ;
	}
}

// file_put_contents

if ( ! function_exists( 'file_put_contents' ) ) {
	function file_put_contents( $path, $contents ) {
		if ( ( $fh = fopen( $path, 'w' ) ) === false ) return false ;
		
		$result = fwrite( $fh, $contents ) ;
		
		fclose( $fh ) ;
		
		return $result ;
	}
}


// define

if ( ! defined( 'XML_ELEMENT_NODE' ) )			define( 'XML_ELEMENT_NODE',			1 ) ;
if ( ! defined( 'XML_TEXT_NODE' ) )				define( 'XML_TEXT_NODE',			3 ) ;
if ( ! defined( 'XML_CDATA_SECTION_NODE' ) )	define( 'XML_CDATA_SECTION_NODE',	4 ) ;
if ( ! defined( 'XML_COMMENT_NODE' ) )			define( 'XML_COMMENT_NODE',			8 ) ;
if ( ! defined( 'XML_DOCUMENT_NODE' ) )			define( 'XML_DOCUMENT_NODE',		9 ) ;


// DOMNode

class jte_DOMNode {
	var $seq ;
	
	var $nodeType ;
	var $parentNode ;
	var $previousSibling ;
	var $nextSibling ;
	
	
	function jte_DOMNode( $nodetype ) {
		jte_DOMNode::__construct( $nodetype ) ;
	}
	
	
	function __construct( $nodetype ) {
		static $_seq = 0 ;
		
		$this->seq = $_seq++ ;
		$this->nodeType = $nodetype ;
		
		$this->ownerDocument = null ;
		$this->parentNode = null ;
		$this->previousSibling = null ;
		$this->nextSibling = null ;
	}
	
	
	// for DEBUG
	
	
	function _debug_node_info( &$node, $tree = false ) {
		$debug = array() ;
		
		$debug[ 'seq' ] = $node->seq ;
		$debug[ 'parentNode' ] = ( is_null( $node->parentNode ) ) ? 'null' : $node->parentNode->seq ;
		$debug[ 'previousSibling' ] = ( is_null( $node->previousSibling ) ) ? 'null' : $node->previousSibling->seq ;
		$debug[ 'nextSibling' ] = ( is_null( $node->nextSibling ) ) ? 'null' : $node->nextSibling->seq ;
		
		switch ( $node->nodeType ) {
			case XML_TEXT_NODE :
				$debug[ 'nodeType' ] = 'XML_TEXT_NODE' ;
				$debug[ 'nodeValue' ] = $node->nodeValue ;
				break ;
			case XML_COMMENT_NODE :
				$debug[ 'nodeType' ] = 'XML_COMMENT_NODE' ;
				$debug[ 'nodeValue' ] = $node->nodeValue ;
				break ;
			case XML_CDATA_SECTION_NODE :
				$debug[ 'nodeType' ] = 'XML_CDATA_SECTION_NODE' ;
				$debug[ 'nodeValue' ] = $node->nodeValue ;
				break ;
			case XML_ELEMENT_NODE :
				$debug[ 'nodeType' ] = 'XML_ELEMENT_NODE' ;
				$debug[ 'tagName' ] = $node->tagName ;
				
				$debug[ 'firstChild' ] = ( is_null( $node->firstChild ) ) ? 'null' : $node->firstChild->seq ;
				$debug[ 'lastChild' ] = ( is_null( $node->lastChild ) ) ? 'null' : $node->lastChild->seq ;
				$debug[ 'childNodes' ] = array() ;
				
				for ( $n = 0 ; $n < $node->childNodes->length ; $n++ ) {
					$child = $node->childNodes->item( $n ) ;
					
					if ( $tree ) {
						$debug[ 'childNodes' ][] = $this->_debug_node_info( $child, true ) ;
					} else {
						$debug[ 'childNodes' ][] = $child->seq ;
					}
				}
				
				break ;
			default :
				$debug[ 'nodeType' ] = 'unknown' ;
		}
		
		return $debug ;
	}
	
	function _debug_node( $tree = false ) {
		echo "<pre>\n" ;
		print_r( $this->_debug_node_info( $this, $tree ) ) ;
		echo "</pre>\n" ;
	}
}


// DOMText

class jte_DOMText extends jte_DOMNode {
	var $nodeValue ;
	
	
	function jte_DOMText( $text = '' ) {
		$this->__construct( $text ) ;
	}
	
	
	function __construct( $text = '' ) {
		parent::jte_DOMNode( XML_TEXT_NODE ) ;
		$this->nodeValue = $text ;
	}
	
	function cloneNode( $deep = false ) {
		return new jte_DOMText( $this->nodeValue ) ;
	}
}


// DOMComment

class jte_DOMComment extends jte_DOMNode {
	var $nodeValue ;
	
	
	function jte_DOMComment( $comment = '' ) {
		$this->__construct( $comment ) ;
	}
	
	
	function __construct( $comment = '' ) {
		parent::jte_DOMNode( XML_COMMENT_NODE ) ;
		$this->nodeValue = $comment ;
	}
	
	
	function cloneNode( $deep = false ) {
		return new jte_DOMComment( $this->nodeValue ) ;
	}
}


// DOMCDATASection

class jte_DOMCDATASection extends jte_DOMNode {
	var $nodeValue ;
	
	
	function jte_DOMCDATASection( $cdata = '' ) {
		$this->__construct( $cdata ) ;
	}
	
	
	function __construct( $cdata = '' ) {
		parent::jte_DOMNode( XML_CDATA_SECTION_NODE ) ;
		$this->nodeValue = $cdata ;
	}
	
	
	function cloneNode( $deep = false ) {
		return new jte_DOMCDATASection( $this->nodeValue ) ;
	}
}


// DOMElement

class jte_DOMElement extends jte_DOMNode {
	var $tagName ;
	var $attributes ;
	var $childNodes ;
	var $firstChild ;
	var $lastChild ;
	
	
	function jte_DOMElement( $tagName ) {
		$this->__construct( $tagName ) ;
	}
	
	
	function __construct( $tagName ) {
		parent::jte_DOMNode( XML_ELEMENT_NODE ) ;
		$this->tagName = $tagName ;
		$this->attributes = new jte_DOMAttributeList() ;
		$this->childNodes = new jte_DOMNodeList() ;
		$this->firstChild = null ;
		$this->lastChild = null ;
	}
	
	
	function _refresh() {
		unset( $this->firstChild ) ;
		unset( $this->lastChild ) ;
		
		$childNodes =& $this->childNodes ;
		
		if ( $childNodes->length == 0 ) {
			$this->firstChild = null ;
			$this->lastChild = null ;
			return ;
		}
		
		$this->firstChild =& $childNodes->item( 0 ) ;
		$this->lastChild =& $childNodes->item( $childNodes->length - 1 ) ;
		
		$siblings = array() ;
		
		$siblings[] = null ;
		
		for ( $n = 0 ; $n < $childNodes->length ; $n++ ) {
			$siblings[] =& $childNodes->item( $n ) ;
		}
		
		$siblings[] = null ;
		
		for ( $n = 0 ; $n < $childNodes->length ; $n++ ) {
			$child =& $childNodes->item( $n ) ;
			
			unset( $child->parentNode ) ;
			$child->parentNode =& $this ;
			
			unset( $child->previousSibling ) ;
			unset( $child->nextSibling ) ;
			
			if ( is_null( $siblings[ $n ] ) ) {
				$child->previousSibling = null ;
			} else {
				$child->previousSibling =& $siblings[ $n ] ;
			}
			
			if ( is_null( $siblings[ $n + 2 ] ) ) {
				$child->nextSibling = null ;
			} else {
				$child->nextSibling =& $siblings[ $n + 2 ] ;
			}
			
			unset( $child ) ;
		}
	}
	
	
	function hasAttribute( $name ) {
		return isset( $this->attributes->_index[ $name ] ) ;
	}
	
	
	function setAttribute( $name, $value ) {
		if ( isset( $this->attributes->_index[ $name ] ) ) {
			$attribute =& $this->attributes->_item[ $this->attributes->_index[ $name ] ] ;
			$attribute->value = $value ;
		} else {
			$this->attributes->_item[] = new jte_DOMAttribute( $name, $value ) ;
		}
		
		$this->attributes->_refresh() ;
	}
	
	
	function getAttribute( $name ) {
		if ( ! isset( $this->attributes->_index[ $name ] ) ) return null ;
		$attribute =& $this->attributes->_item[ $this->attributes->_index[ $name ] ] ;
		return $attribute->value ;
	}
	
	
	function removeAttribute( $name ) {
		if ( ! isset( $this->attributes->_index[ $name ] ) ) return ;
		
		$index = $this->attributes->_index[ $name ] ;
		
		array_splice( $this->attributes->_item, $index, 1 ) ;
		
		$this->attributes->_refresh() ;
	}
	
	
	function & appendChild( &$node ) {
		unset( $node->parentNode ) ;
		$node->parentNode =& $this ;
		
		$childNodes =& $this->childNodes ;
		$childNodes->_item[] = $node ;
		$childNodes->_refresh() ;
		
		$this->_refresh() ;
		
		unset( $node ) ;
		$node =& $this->lastChild ;
		
		return $node ;
	}
	
	
	function & insertBefore( &$node, &$before ) {
		if ( $before->parentNode->seq != $this->seq ) {
			echo "insertBefore: error parent(" . var_dump( $before ) . ")<br />\n" ;
			return $node ;
		}
		
		$childNodes =& $this->childNodes ;
		
		if ( isset( $childNodes->_index[ $before->seq ] ) ) {
			$n = $childNodes->_index[ $before->seq ] ;
			
			unset( $node->parentNode ) ;
			$node->parentNode =& $this ;
			array_splice( $childNodes->_item, $n, 0, array( $node ) ) ;
			$childNodes->_refresh() ;
			
			$this->_refresh() ;
			
			$node =& $childNodes->item( $n ) ;
			
			return $node ;
		}
		
		echo "insertBefore: error not child<br />\n" ;
		
		return $node ;
	}
	
	
	function replaceChild( &$node, &$replace ) {
		if ( $replace->parentNode->seq != $this->seq ) {
			echo "replaceChild: error<br />\n" ;
			return false ;
		}
		
		$childNodes =& $this->childNodes ;
		
		if ( isset( $childNodes->_index[ $replace->seq ] ) ) {
			$n = $childNodes->_index[ $replace->seq ] ;
			
			unset( $node->parentNode ) ;
			$node->parentNode =& $this ;
			$childNodes->_item[ $n ] = $node ;
			$childNodes->_refresh() ;
			
			$this->_refresh() ;
			
			return $node ;
		}
		
		return null ;
	}
	
	
	function removeChild( &$node ) {
		if ( $node->parentNode->seq != $this->seq ) {
			echo "removeChild: error<br />\n" ;
			return false ;
		}
		
		$childNodes =& $this->childNodes ;
		
		if ( isset( $childNodes->_index[ $node->seq ] ) ) {
			$n = $childNodes->_index[ $node->seq ] ;
			
			array_splice( $childNodes->_item, $n, 1 ) ;
			$childNodes->_refresh() ;
			
			$this->_refresh() ;
		}
		
		return $node ;
	}
	
	
	function cloneNode( $deep = false ) {
		$clone = new jte_DOMElement( $this->tagName ) ;
		
		for ( $n = 0 ; $n < $this->attributes->length ; $n++ ) {
			$attribute =& $this->attributes->item( $n ) ;
			$clone->setAttribute( $attribute->name, $attribute->value ) ;
			unset( $attribute ) ;
		}
		
		if ( $deep ) {
			for ( $n = 0 ; $n < $this->childNodes->length ; $n++ ) {
				$child =& $this->childNodes->item( $n ) ;
				$clone->appendChild( $child->cloneNode( true ) ) ;
				unset( $child ) ;
			}
		}
		
		return $clone ;
	}
}


// DOMNodeList

class jte_DOMNodeList {
	var $length ;
	var $_item ;
	var $_index ;
	
	
	function jte_DOMNodeList() {
		$this->__construct() ;
	}
	
	
	function __construct() {
		$this->_item = array() ;
		$this->_refresh() ;
	}
	
	
	function _refresh() {
		$this->length = count( $this->_item ) ;
		
		$this->_index = array() ;
		
		for ( $n = 0 ; $n < $this->length ; $n++ ) {
			$item =& $this->_item[ $n ] ;
			$this->_index[ $item->seq ] = $n ;
			unset( $item ) ;
		}
	}
	
	
	function & item( $index ) {
		if ( isset( $this->_item[ $index ] ) ) {
			$item =& $this->_item[ $index ] ;
			return $item ;
		}
		
		return null ;
	}
}


// DOMAttribute

class jte_DOMAttribute {
	var $neme ;
	var $value ;
	
	
	function jte_DOMAttribute( $name, $value ) {
		$this->__construct( $name, $value ) ;
	}
	
	
	function __construct( $name, $value ) {
		$this->name = $name ;
		$this->value = $value ;
	}
}


// DOMAttributeList

class jte_DOMAttributeList {
	var $length ;
	
	var $_item ;
	var $_index ;
	
	
	function jte_DOMAttributeList() {
		$this->__construct() ;
	}
	
	
	function __construct() {
		$this->_item = array() ;
		$this->_refresh() ;
	}
	
	
	function _refresh() {
		$this->length = count( $this->_item ) ;
		
		$this->_index = array() ;
		
		for ( $n = 0 ; $n < $this->length ; $n++ ) {
			$item =& $this->_item[ $n ] ;
			$this->_index[ $item->name ] = $n ;
			unset( $item ) ;
		}
	}
	
	
	function & item( $index ) {
		if ( isset( $this->_item[ $index ] ) ) {
			$item =& $this->_item[ $index ] ;
			return $item ;
		}
		
		return null ;
	}
}


// DOMDocumentType

class jte_DOMDocumentType {
	var $internalId = '' ;
	var $name = '' ;
	var $publicId = '' ;
	var $systemId = '' ;
	
	
	function jte_DOMDocumentType() {
		$this->__construct() ;
	}
	
	
	function __construct() {
		$this->_parse( '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">' ) ;
	}
	
	
	function _parse( $doctype ) {
		if ( mb_eregi( '^\<!DOCTYPE[\s\n]+([^\s\n]+)[\s\n]+PUBLIC[\s\n]+("[^"]*")[\s\n]+("[^"]*")[\s\n]*\>$', trim( $doctype ), $part ) ) {
			$this->internalId = trim( $doctype ) ;
			$this->name = strtolower( $part[ 1 ] ) ;
			$this->publicId = $part[ 2 ] ;
			$this->systemId = $part[ 3 ] ;
		}
	}
}


// DOMDocument

class jte_DOMDocument {
	var $encoding = 'UTF-8' ;
	var $doctype = null ;
	var $documentElement = null ;
	var $ownerDocument ;
	
	var $nodeType ;
	
	
	function jte_DOMDocument() {
		$this->__construct() ;
	}
	
	
	function __construct() {
		$this->nodeType = XML_DOCUMENT_NODE ;
		$this->doctype = new jte_DOMDocumentType() ;
		return true ;
	}
	
	
	function & appendChild( &$node ) {
		$node->parentNode =& $this ;
		$this->documentElement = $node ;
		
		return $this->documentElement ;
	}
	
	
	function createComment( $comment = '' ) {
		$node = new jte_DOMComment( $comment ) ;
		$node->ownerDocument =& $this ;
		return $node ;
	}
	
	
	function createTextNode( $text = '' ) {
		$node = new jte_DOMText( $text ) ;
		$node->ownerDocument =& $this ;
		return $node ;
	}
	
	
	function createCDATASenction( $cdata = '' ) {
		$node = new jte_DOMCDATASection( $cdata ) ;
		$node->ownerDocument =& $this ;
		return $node ;
	}
	
	
	function createElement( $tagName, $nodeValue = null ) {
		$node = new jte_DOMElement( $tagName ) ;
		$node->ownerDocument =& $this ;
		
		if ( ! is_null( $nodeValue ) ) {
			$node->appendChild( $this->createTextNode( $nodeValue ) ) ;
		}
		
		return $node ;
	}
	
	
	function saveXML() {
		$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" ;
		
		$this->_tree( $xml, $this->documentElement, '' ) ;
		
		return $xml ;
	}
	
	
	function _tree( &$xml, $node, $tab ) {
		switch ( $node->nodeType ) {
			case XML_ELEMENT_NODE :
				$tag = array( $node->tagName )   ;
				
				$attributes =& $node->attributes ;
				
				for ( $n = 0 ; $n < $attributes->length ; $n++ ) {
					$attribute =& $attributes->item( $n ) ;
					
					$name = $attribute->name ;
					$value = $attribute->value ;
					
					$tag[] = htmlspecialchars( $name ) . '="' . $value . '"' ;
				}
				
				switch ( $node->childNodes->length ) {
					case 0 :
						$xml .= "{$tab}<" . implode( ' ', $tag ) . "/>\n" ;
						break ;
					
					case 1 :
						$child = $node->childNodes->item( 0 ) ;
						
						if ( $child->nodeType == XML_ELEMENT_NODE ) {
							$xml .= "{$tab}<" . implode( ' ', $tag ) . ">\n" ;
							$this->_tree( $xml, $child, "{$tab}  " ) ;
							$xml .= "{$tab}</" . $node->tagName . ">\n" ;
						} else {
							$xml .= "{$tab}<" . implode( ' ', $tag ) . ">" ;
							$this->_tree( $xml, $child, "" ) ;
							$xml .= "</" . $node->tagName . ">\n" ;
						}
						
						break ;
					
					default :
						$xml .= "{$tab}<" . implode( ' ', $tag ) . ">\n" ;
						
						for ( $n = 0 ; $n < $node->childNodes->length ; $n++ ) {
							$this->_tree( $xml, $node->childNodes->item( $n ), "{$tab}  " ) ;
						}
						
						$xml .= "{$tab}</" . $node->tagName . ">\n" ;
				}
				
				break ;
			
			case XML_COMMENT_NODE :
				$xml .= "<!--" . $node->nodeValue . "-->" ;
				break ;
			
			case XML_CDATA_SECTION_NODE :
				$xml .= "<![CDATA[" . $node->nodeValue . "]]>" ;
				break ;
			
			default :
				$xml .= str_replace( '&#039;', '&apos;', htmlspecialchars( $node->nodeValue, ENT_QUOTES ) ) ;
		}
	}
}
?>